<?php
/*--------------------------------------------------------------------
 OnGetSellingUnitWeightEventInterface.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

namespace Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Weight;
use ProductDataInterface;

/**
 * Interface OnGetSellingUnitWeightEventInterface
 * @package Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces
 */
interface OnGetSellingUnitWeightEventInterface
{
    /**
     * @return ProductId
     */
    public function productId(): ProductId;
    
    
    /**
     * @return ModifierIdentifierCollectionInterface
     */
    public function modifiers(): ModifierIdentifierCollectionInterface;
    
    
    /**
     * @return ProductDataInterface
     */
    public function product(): ProductDataInterface;
    
    
    /**
     * @return Weight
     */
    public function weight(): Weight;
    
    
    /**
     * @param Weight $weight
     */
    public function setWeight(Weight $weight): void;
}